# (c) Copyright 2005, 2010, 2014. CodeWeavers, Inc.
package CXAssocDebian;
use warnings;
use strict;

use CXLog;
use CXUtils;
use CXAssocMcap;
use base "CXAssocMcap";


#####
#
# Main
#
#####

sub read_mailcap($)
{
    my ($self)=@_;
    if (!$self->{rwmcap})
    {
        my $filename="$self->{assoc}/cxassoc-$self->{tag}";
        cxlog("Reading '$filename'\n");
        $self->{rwmcap}=CXRWBlob->new($self->{tag}, $filename,
                                      "mailcap", $self->{multiline});
    }
    return $self->{rwmcap};
}

sub detect($$$$)
{
    my ($class, $cxoptions, $cxconfig, $gui_info)=@_;
    return () if (!$gui_info->{debian_mime_on} or
                  !$gui_info->{debian_preferred_assoc} or
                  # Debian associations are for root only
                  $> != 0);

    my $self=CXAssocMcap->new("deb", $cxoptions, $cxconfig, $gui_info);
    $self->{assoc} = "$cxoptions->{destdir}$gui_info->{debian_preferred_assoc}";
    bless $self, $class;
    return ($self);
}

sub id($)
{
    my ($self)=@_;
    my $id="CXAssocDebian/$self->{assoc}";
    $id =~ s%/+%/%g;
    return $id;
}

sub removeall($$)
{
    my ($self, $pattern)=@_;
    $self->{mimes}->removeall($self->{domain}, $pattern);

    if ($pattern eq "legacy")
    {
        $pattern="^" . CXUtils::get_product_id() . "\$";
    }
    else
    {
        $pattern="^cxassoc-$pattern";
    }
    CXUtils::delete_files($self->{assoc}, $pattern);

    return 1;
}

sub finalize($)
{
    my ($self)=@_;

    my $rc=$self->SUPER::finalize();
    cxsystem("update-mime") if (!$self->{destdir});
    return $rc;
}

return 1;
